(* ocamlc str.cma clean_comments.ml *)

open Printf;;

let filename = "test";;

let input_channel = open_in filename;;

let output_channel = open_out (filename ^ ".mod");;

let rec copy_file ic oc =
  try
    let line = input_line ic in
    let stripped_line = Str.global_replace (Str.regexp "^(\\(\\*\\*.*\\))$") "" line in
      fprintf oc "%s\n" stripped_line;
      copy_file ic oc
  with e ->
    match e with
	End_of_file -> close_in_noerr ic; close_out oc
      | _ -> raise e
;;


let _ =
  copy_file input_channel output_channel;;   
