(*
  Panoptes: An Exploration Tool for Formal Proofs
  Copyright (C) 2008  Orlin Grigorov

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.

  To contact the author, email to: ogrigorov at gmail.com
*)


open Printf
open Images

let filename = "font.jpg";;
(*
created with:
./ttf2png -o font.png -r32,127 -s40 -l128 -c33 -a courbd.ttf

*)

let char_w = 33
and char_h = 64;;

let start_char_code = 32
and finish_char_code = 127;;

let h_adjustment = 20;;
let h_adjustment_bottom = 5;;


let current_directory = Sys.getcwd();;


let save_in_file c image c_w c_h =
  let oc = open_out_bin (current_directory ^ "/font/character_" ^ string_of_int(c) ^ ".img") in
  let str = Raw.gets_string image ~pos:0 ~len:(Raw.byte_size image) in
    print_endline ("output size = " ^ string_of_int(Raw.byte_size image));
    output_binary_int oc c_w;
    output_binary_int oc c_h;
    output_string oc str; 
    close_out oc
;;
  
let make_image() =
  print_string "Building font"; flush stdout;
  let img = OImages.load filename [] in
  let cimg = OImages.rgb24 img in
    for c = start_char_code to finish_char_code do 
      let image = GlPix.create `ubyte ~format:`rgb 
	~width:char_w ~height:(char_h-h_adjustment-h_adjustment_bottom) in
      let pos = c * char_w in
	for h = h_adjustment to char_h - 1 - h_adjustment_bottom do
	  for w = pos to pos + char_w - 1 do
	    let pixel = cimg#get (2*pos+char_w-1-w) h in
	    let red = pixel.r in
	    let green = pixel.g in
	    let blue = pixel.b in
	      Raw.sets (GlPix.to_raw image) ~pos:(3*((h-h_adjustment)*char_w+w-pos)) 
		[| red; green; blue |]
	  done;
	done; 
	save_in_file c (GlPix.to_raw image) char_w (char_h-h_adjustment-h_adjustment_bottom);
	print_char '.'; flush stdout;
      done;
      print_endline "done."
;;



let _ =
  Sys.command "mkdir font";
  make_image()
;;

