(** *)
(*
  Panoptes: An Exploration Tool for Formal Proofs
  Copyright (C) 2008  Orlin Grigorov

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.

  To contact the author, email to: ogrigorov at gmail.com
*)


class sqn_grabber (filename:string) =
  let backup_filename = filename ^ ".mod" in
object(self)

  (** This variable holds an indicator of the time format, which is platform dependent (in OS X and Linux it is in the form of a real number).  It is used for comparison with the current timestamp of the file that is monitored for changes.  Every time the file changes, the object of this class will detect this as an even and will update this variable accordingly. *)
  val mutable last_modtime = 0.

  (** This method stops the tread and removes the backup file from the disk (the file, which is used for storing any detected new data).  *)
  method stop() =
    Sys.remove backup_filename;  
    ()

  (** This method ``polls'' the file that is being monitored.  If an update is detected, then it creates a backup of the newly introduced data.  Also, it transmits a notification message to the [Panoptes] module, letting it know that it should notify the user about the detection of new data.  Consequently  Panoptes displays an indication on the screen that prompts the user to press the ``UPDATE'' shortcut in the user interface.  *) 
  method poll() =
    let result = ref false in
    let modtime = (Unix.stat filename).Unix.st_mtime in
      if (modtime > last_modtime) then
	begin
	  last_modtime <- modtime;
	  print_endline "\nNEW DATA DETECTED, click UPDATE button!";
	  result := true;
	  let oc = open_out_gen [Open_append; Open_binary] 1 backup_filename in
	  let ic = open_in_bin filename in
	  let size = in_channel_length ic in
	  let buffer = String.create size in
	    really_input ic buffer 0 size;
	    output_string oc buffer;
	    close_in ic;
	    close_out oc;
	    flush stdout;
	end;
    !result

  initializer
    if (Sys.file_exists filename = false) then failwith (filename ^ " does not exist!!!!!")
    else 
      begin
	last_modtime <- (Unix.stat filename).Unix.st_mtime;
    	let _ = Sys.command ("cp " ^ filename ^ " " ^ backup_filename) in
	  ()
      end;
    ()

end;;
