(** *)
(*
  Panoptes: An Exploration Tool for Formal Proofs
  Copyright (C) 2008  Orlin Grigorov

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.

  To contact the author, email to: ogrigorov at gmail.com
*)


(** This type is used to indicate whether something represents a sequent node or an inference node. *)
type kindT = SQN | INF;;

(** This type is provided for use by the parser.  The different kinds of nodes in the deduction graph are labeled differently.  Recall that IMPS automatically labels repeating and grounded nodes in its text representation of the deduction graph.  The ``Box'' value is used later in the implementation to signify a node that represents a collapsed part of the graph. *)
type specialT = Nil | Repeated | Grounded | Box;;

(** This is a recursive type that is used for representing nodes in the graph.  Each record of this type consists of a tuple of elements:  the kind of the node, its name (or label), its special characteristics, and a list of other nodes it is connected to.  This resembles the design of a linked list. *)
type nodeT = Node of kindT * string * specialT * nodeT list;;

(** This is used to represent a collection (or list) of nodes.  This type is not very important, but its presence makes implementation more convenient and less confusing.  When programming in OCaml it is important to specify the types in advance, so that the built in type inference system of the compiler produces performs better. *)
type sqnT = (int * specialT * string) list;;

(** The number Pi to be used throughout all modules of Panoptes.  Here it is calculated to a great enough precision to accommodate some graphical calculations used in the other modules.  *)
let pi = acos (-1.);;
